# -*- coding: utf-8 -*-
import argparse

from passport.backend.takeout.common.conf import configure_settings
from passport.backend.takeout.common.conf.services import get_service_configs
from passport.backend.takeout.common.touch import TouchFiles


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('prefixes', nargs='*')
    parser.add_argument('--unset', action='store_true', default=False)
    parser.add_argument('--done', action='store_true', default=False)
    parser.add_argument('--started', action='store_true', default=False)
    parser.add_argument('--ordered', action='store_true', default=False)

    return parser.parse_args()


def run_app():
    args = parse_args()

    configure_settings()

    service_cfg = get_service_configs()

    for prefix in args.prefixes:
        if '/' in prefix:
            print(f'{prefix} is skipped. Use ":" instead of "/" as a delimeter')
            continue
        uid, extract_id, service_name = prefix.split(':')

        service_type = service_cfg[service_name].type

        touch_files = []

        if service_type == 'sync':
            if args.done:
                touch_files.append(TouchFiles.Sync.DONE)
            if args.started:
                touch_files.append(TouchFiles.Sync.STARTED)
        elif service_type == 'async':
            if args.done:
                touch_files.append(TouchFiles.AsyncPoll.DONE)
            if args.started:
                touch_files.append(TouchFiles.AsyncPoll.STARTED)
        elif service_type == 'async_upload':
            if args.done:
                touch_files.append(TouchFiles.AsyncUpload.DONE)
            if args.started:
                touch_files.append(TouchFiles.AsyncUpload.STARTED)
            if args.ordered:
                touch_files.append(TouchFiles.AsyncUpload.ORDERED_DATA)

        touch_client = TouchFiles(uid, extract_id, service_name)

        for touch_file in touch_files:
            if args.unset:
                print('unset', uid, extract_id, service_name, touch_file)
                touch_client.unset(touch_file)
            else:
                print('set', uid, extract_id, service_name, touch_file)
                touch_client.set(touch_file)
