# -*- coding: utf-8 -*-
import logging
import time

from passport.backend.core.protobuf.takeout.takeout_pb2 import TakeoutRequest
from passport.backend.takeout.common.logbroker import get_takeout_logbroker_writer
from passport.backend.takeout.logbroker_client.exception_handler import process_exception
from passport.backend.takeout.logbroker_client.tasks.cleanup import cleanup_local


log = logging.getLogger('takeout.tasks.make_archive')


def send_cleanup(source, task_id, uid, extract_id, unixtime, max_retries=0, retries=0, delay_until=0):
    task_base_message = TakeoutRequest.TaskBaseMessage(
        task_id=task_id,
        uid=uid,
        extract_id=extract_id,
        unixtime=unixtime,
        task_name='cleanup',
        retries=retries,
        max_retries=max_retries,
        delay_until=delay_until,
        source=source,
        send_time=int(time.time()),
    )

    try:
        logbroker = get_takeout_logbroker_writer('takeout_tasks')

        logbroker.send(
            TakeoutRequest(task_base_message=task_base_message)
        )
        return True
    except Exception as e:
        statbox_params = {
            'archive_requested_unixtime': unixtime,
        }
        process_exception(
            task_id=task_id,
            uid=uid,
            extract_id=extract_id,
            task_name='cleanup',
            statbox_params=statbox_params,
            e=e,
        )
        return False


def cleanup_task(uid, extract_id):
    cleanup_local(
        uid=uid,
        extract_id=extract_id,
    )
