# -*- coding: utf-8 -*-

import logging

from passport.backend.takeout.common.logbroker import get_takeout_logbroker_writer
from passport.backend.takeout.logbroker_client.exception_handler import (
    LogbrokerWriterError,
    process_exception,
)
from passport.backend.takeout.logbroker_client.extract_task_message import ExtractTaskMessage


log = logging.getLogger('takeout.tasks.download_user_data')


def send_extract_task_message(
    source,
    task_id,
    uid,
    extract_id,
    unixtime,
    services=None,
    retries=0,
    max_retries=0,
    delay_until=0,
    manual_takeout=None,
):
    extract_task_message = ExtractTaskMessage(
        delay_until=delay_until,
        extract_id=extract_id,
        manual_takeout=manual_takeout,
        max_retries=max_retries,
        retries=retries,
        services=services,
        task_id=task_id,
        uid=uid,
        unixtime=unixtime,
        source=source,
    )
    try:
        logbroker = get_takeout_logbroker_writer('takeout_tasks')
        logbroker.send(extract_task_message.takeout_request)
    except Exception as e:
        statbox_params = {
            'services': extract_task_message.services,
            'archive_requested_unixtime': extract_task_message.unixtime,
        }
        process_exception(
            task_id=extract_task_message.task_id,
            uid=extract_task_message.uid,
            extract_id=extract_task_message.extract_id,
            task_name='send_extract',
            statbox_params=statbox_params,
            e=e,
            retries=extract_task_message.retries,
            max_retries=extract_task_message.max_retries,
        )

        raise LogbrokerWriterError("Force error raise: send 'extract' message failed")
