# -*- coding: utf-8 -*-
import time
import uuid

from passport.backend.core.protobuf.takeout.takeout_pb2 import TakeoutRequest


def get_task_id():
    return str(uuid.uuid4())[-8:]


def get_extract_id():
    return uuid.uuid4().hex


class ExtractTaskMessage(object):
    def __init__(
        self,
        extract_id,
        task_id,
        uid,
        unixtime,
        delay_until=0,
        max_retries=0,
        retries=0,
        services=None,
        manual_takeout=None,
        source='takeout',
    ):
        self.delay_until = delay_until
        self.extract_id = extract_id
        self.manual_takeout = manual_takeout
        self.max_retries = max_retries
        self.retries = retries
        self.services = list() if services is None else services
        self.task_id = task_id
        self.uid = uid
        self.unixtime = unixtime
        self.source = source

    @property
    def takeout_request(self):
        return TakeoutRequest(task_base_message=self._base_message, extract=self._detail_message)

    @property
    def _base_message(self):
        return TakeoutRequest.TaskBaseMessage(
            delay_until=self.delay_until,
            extract_id=self.extract_id,
            max_retries=self.max_retries,
            retries=self.retries,
            task_id=self.task_id,
            task_name='extract',
            uid=self.uid,
            unixtime=self.unixtime,
            source=self.source,
            send_time=int(time.time()),
        )

    @property
    def _detail_message(self):
        return TakeoutRequest.TaskExtractMessage(
            is_manual_takeout=bool(self.manual_takeout),
            services=self.services,
        )
