# -*- coding: utf-8 -*-
import logging
import time

from passport.backend.core.protobuf.takeout.takeout_pb2 import TakeoutRequest
from passport.backend.takeout.common.logbroker import get_takeout_logbroker_writer
from passport.backend.takeout.logbroker_client.exception_handler import (
    LogbrokerWriterError,
    process_exception,
)


log = logging.getLogger('takeout.tasks.download_user_data')


def resend_message(source, message):
    task_base = message.task_base_message
    task_base.seq += 1
    task_base.source = source
    task_base.send_time = int(time.time())
    new_message = dict(task_base_message=task_base)

    statbox_params = {}
    if task_base.task_name == 'extract':
        new_message.update(extract=message.extract)
    elif task_base.task_name == 'extract_service':
        new_message.update(extract_service=message.extract_service)
        statbox_params.update(service_name=message.extract_service.service)
    elif task_base.task_name == 'make_archive':
        new_message.update(make_archive=message.make_archive)

    try:
        takeout_request = TakeoutRequest(**new_message)
        logbroker = get_takeout_logbroker_writer('takeout_tasks')
        logbroker.send(takeout_request)
    except Exception as e:
        process_exception(
            task_id=task_base.task_id,
            uid=task_base.uid,
            extract_id=task_base.extract_id,
            task_name=task_base.task_name,
            statbox_params=statbox_params,
            e=e,
            retries=task_base.retries,
            max_retries=task_base.max_retries,
        )

        raise LogbrokerWriterError("Force error raise: resend '%s' message failed" % task_base.task_name)
