# -*- coding: utf-8 -*-
from passport.backend.takeout.common.builders import (
    AsyncServiceBuilder,
    STATUS_NO_DATA,
)
from passport.backend.takeout.common.touch import TouchFiles
from passport.backend.takeout.common.utils import download_file_links_and_encrypt_and_upload_to_s3


def async_task_start(uid, extract_id, service_name, unixtime, conf=None):
    touch = TouchFiles(uid, extract_id, service_name)

    # Ничего здесь не пропускаем в зависимости от тач-файлов, потому что надо вместо return вернуть return job_id
    # А мы его не знаем на этот момент и никуда его не сохраняем

    builder = AsyncServiceBuilder(service_name=service_name, conf=conf)

    rv = builder.start(uid, unixtime=unixtime)

    if rv['status'] == STATUS_NO_DATA:
        # в async_task_get передастся None вместо job_id и async_task_get не будет ничего пытаться сделать
        # сразу завершится
        job_id = None
    else:
        job_id = rv['job_id']

    # Успешно сходили в ручку, отмечаем это соответствующим тач-файлом
    touch.set(TouchFiles.AsyncPoll.STARTED, skip_errors=True)

    return job_id


def async_task_get(uid, extract_id, service_name, job_id, conf=None):
    touch = TouchFiles(uid, extract_id, service_name)
    # ничего не делать, уже всё сделано
    if touch.is_set(TouchFiles.AsyncPoll.DONE):
        return

    # async_task_start получил STATUS_NO_DATA от сервиса и поэтому скачивать нечего
    # досрочно завершаем процесс
    if job_id is None:
        touch.set(TouchFiles.AsyncPoll.DONE, skip_errors=True)
        return

    # Не проверяем наличие STARTED, т.к. его установка могла окончиться ошибкой и это не фатально

    builder = AsyncServiceBuilder(service_name=service_name, conf=conf)
    rv = builder.get_info(job_id)

    download_file_links_and_encrypt_and_upload_to_s3(
        uid=uid,
        extract_id=extract_id,
        service_name=service_name,
        builder=builder,
        builder_response=rv,
        use_redis_cache=True,
    )

    # Завершили процесс, отмечаем это соответствующим тач-файлом
    touch.set(TouchFiles.AsyncPoll.DONE, skip_errors=True)
