# -*- coding: utf-8 -*-
from passport.backend.takeout.common.builders import (
    AsyncUploadServiceBuilder,
    STATUS_NO_DATA,
)
from passport.backend.takeout.common.exceptions import ResponseNotReadyError
from passport.backend.takeout.common.touch import TouchFiles


def async_upload_task_start(uid, extract_id, service_name, unixtime, job_id, statbox, conf=None):
    touch = TouchFiles(uid, extract_id, service_name)

    # задача уже сделана, ничего не надо делать
    if touch.is_set(TouchFiles.AsyncUpload.DONE):
        return
    # данные уже заказаны, тоже нечего делать
    if touch.is_set(TouchFiles.AsyncUpload.ORDERED_DATA):
        return

    # начинаем принимать файлы в upload при наличии такого файла
    # Важно не пропускать здесь ошибки, иначе задача будет ожидать завершения, но файлы приниматься не будут
    touch.set(TouchFiles.AsyncUpload.STARTED, skip_errors=False)

    builder = AsyncUploadServiceBuilder(service_name=service_name, conf=conf)
    rv = builder.start(uid, unixtime=unixtime, job_id=job_id)

    # не выполняем задачу повторно, если есть такой файл
    touch.set(TouchFiles.AsyncUpload.ORDERED_DATA, skip_errors=True)

    # Если данных по пользователю нет, то сразу выставляем DONE, чтобы async_upload_task_get быстро завершилась
    if rv['status'] == STATUS_NO_DATA:
        # Важно не пропускать здесь ошибки, иначе задача рискует никогда не закончиться
        touch.set(TouchFiles.AsyncUpload.DONE, skip_errors=False)


def async_upload_task_get(uid, extract_id, service_name):
    touch = TouchFiles(uid, extract_id, service_name)

    if not touch.is_set(TouchFiles.AsyncUpload.DONE):
        raise ResponseNotReadyError('%s not ready' % service_name)
