# -*- coding: utf-8 -*-
import logging

from passport.backend.core.s3 import (
    DELIMITER,
    get_s3_client,
)
from passport.backend.takeout.common.utils import ignore_s3_file


log = logging.getLogger('takeout.tasks.cleanup')


S3_CHUNK_SIZE = 100  # <= 1000


def cleanup_local(uid, extract_id):
    """
    Очистка временных файлов текущей выгрузки в S3. Если не получилось удалить - не страшно,
    вычистятся глобальной таской.
    """
    s3 = get_s3_client()

    deleted_count = 0

    for chunk in s3.iterate_files_by_chunks(
        folder=DELIMITER.join([str(uid), extract_id]),
        chunk_size=S3_CHUNK_SIZE,
    ):
        for file_info in chunk:
            if ignore_s3_file(file_info['Key']):
                # touch-файлы нам могут пригодиться для дебага. Не будем тут их удалять (они удалятся глобальной таской)
                continue

            # TODO: перейти на delete_objects, чтобы удалять балком и сэкономить http-запросы
            s3.delete_file(key=file_info['Key'])  # если файла уже нет - delete ошибки не кинет
            log.debug('%s deleted from S3', file_info['Key'])
            deleted_count += 1

    log.info('Local cleanup done for uid=%s, extract_id=%s: deleted %s files', uid, extract_id, deleted_count)
