# -*- coding: utf-8 -*-
from passport.backend.takeout.common.builders import SyncServiceBuilder
from passport.backend.takeout.common.touch import TouchFiles
from passport.backend.takeout.common.utils import download_file_links_and_encrypt_and_upload_to_s3


def sync_task(uid, extract_id, service_name, unixtime, conf=None):
    touch = TouchFiles(uid, extract_id, service_name)

    if touch.is_set(TouchFiles.Sync.DONE):
        return

    builder = SyncServiceBuilder(service_name=service_name, conf=conf)
    rv = builder.get_info(uid, unixtime=unixtime)

    # Успешно сходили в ручку, отмечаем это соответствующим тач-файлом
    # Флаг этот нигде не проверяем, т.к. процесс здесь более-менее одношаговый
    # и нечего здесь пропускать, кроме всего процесса целиком - для этого есть флаг DONE
    touch.set(TouchFiles.Sync.STARTED, skip_errors=True)

    download_file_links_and_encrypt_and_upload_to_s3(
        uid=uid,
        extract_id=extract_id,
        service_name=service_name,
        builder=builder,
        builder_response=rv,
        use_redis_cache=True,
    )

    touch.set(TouchFiles.Sync.DONE, skip_errors=True)
