import logging

from ci.tasklet.common.proto import service_pb2 as ci
from passport.backend.clients.conductor import ConductorClient
from passport.backend.tasklets.conductor.proto import (
    create_pb2,
    create_tasklet,
)
from tasklet.services.yav.proto import yav_pb2


logger = logging.getLogger(__name__)


class CreateConductorTicketImpl(create_tasklet.CreateConductorTicketBase):
    def run(self):
        progress_msg = ci.TaskletProgress()
        progress_msg.job_instance_id.CopyFrom(self.input.context.job_instance_id)
        progress_msg.module = 'CONDUCTOR'
        self.ctx.ci.UpdateProgress(progress_msg)

        spec = yav_pb2.YavSecretSpec(uuid=self.input.context.secret_uid, key='conductor.token')
        oauth_token = self.ctx.yav.get_secret(spec).secret
        conductor_client = ConductorClient(token=oauth_token)

        package = self.input.ticket.package
        if not package:
            raise ValueError('Package is not set')

        version = self.input.ticket.version
        if not version:
            raise ValueError('Version is not set')

        branch = self.input.ticket.branch
        if branch is None:
            raise ValueError('Branch is not set')
        branch_name = create_pb2.Branch.Name(branch).lower()

        ticket_url = conductor_client.create_ticket(
            packages_with_versions=[
                {
                    'package': package,
                    'version': version,
                },
            ],
            comment=self.input.ticket.comment,
            branch=branch_name,
            do_not_autoinstall=self.input.ticket.do_not_autoinstall,
        )

        self.output.result.url = ticket_url
        self.output.result.key = ticket_url.rstrip('/').rsplit('/', 1)[-1]

        progress_msg.url = ticket_url
        progress_msg.text = 'Тикет'
        progress_msg.status = ci.TaskletProgress.Status.SUCCESSFUL
        self.ctx.ci.UpdateProgress(progress_msg)
