import logging

from ci.tasklet.common.proto import service_pb2 as ci
from passport.backend.tasklets.startrek.proto import create_tasklet
from startrek_client import Startrek
from tasklet.services.yav.proto import yav_pb2


logger = logging.getLogger(__name__)


class CreateIssueImpl(create_tasklet.CreateIssueBase):
    def run(self):
        progress_msg = ci.TaskletProgress()
        progress_msg.job_instance_id.CopyFrom(self.input.context.job_instance_id)
        progress_msg.module = 'STARTREK'
        self.ctx.ci.UpdateProgress(progress_msg)

        spec = yav_pb2.YavSecretSpec(uuid=self.input.context.secret_uid, key='startrek.token')
        oauth_token = self.ctx.yav.get_secret(spec).secret
        startrek_client = Startrek(
            useragent='Passport CI',
            base_url='https://st-api.yandex-team.ru',
            token=oauth_token,
        )

        summary = self.input.issue.summary
        if not summary:
            raise ValueError('Summary is not set')

        kwargs = dict(
            queue=self.input.issue.queue or 'PASSP',
            createdBy=self.input.context.flow_triggered_by,
            summary=summary,
            description=self.input.issue.description,
            type={'name': self.input.issue.type or 'Task'},
            components=list(self.input.issue.components or []),
        )
        if self.input.issue.assignee:
            kwargs.update(assignee=self.input.issue.assignee)

        response = startrek_client.issues.create(**kwargs)
        issue_key = response.key

        self.output.result.key = issue_key
        self.output.result.url = 'https://st.yandex-team.ru/%s' % issue_key

        progress_msg.url = self.output.result.url
        progress_msg.text = 'Тикет'
        progress_msg.status = ci.TaskletProgress.Status.SUCCESSFUL
        self.ctx.ci.UpdateProgress(progress_msg)
