# -*- coding: utf-8 -*-

import logging
from logging.config import dictConfig
import sys
import traceback

from passport.backend.tools.as_data_generator import (
    generator,
    settings,
)
from passport.backend.tools.as_data_generator.exceptions import BasePassportAsDataGenerator
from passport.backend.tools.as_data_generator.utils import send_email


log = logging.getLogger(__name__)


def handle_error(message, exception):
    formatted_tb = traceback.format_exc()
    log.error('%s: %s', message, exception)
    log.exception(exception)
    send_email('%s:\n%s\n%s' %(message, exception, formatted_tb))
    sys.exit(1)


def main():
    dictConfig(settings.LOGGING)

    log.info('AS data generator started')
    try:
        generator.generate_as_data(
            settings.AS_DATA_REPO,
            username=settings.CHANGELOG_USERNAME,
            usermail=settings.CHANGELOG_EMAIL,
        )
    except BasePassportAsDataGenerator as e:
        return handle_error('AS data generator failed with error', e)
    except Exception as e:
        return handle_error('AS data generator failed with unhandled exception', e)
    log.info('AS data generator successfully finished')
    sys.exit(0)
