# -*- coding: utf-8 -*-
import os


LOG_PATH = '/var/log/yandex/passport-as-data-generator/'

if os.environ.get('DEBUG') == '1':
    LOG_PATH = './'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
    },
    'root': {
        'handlers': ['passport_as_data_generator.info'],
        'level': 'DEBUG',
    },
    'handlers': {
        'passport_as_data_generator.info': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'info.log',
            'level': 'DEBUG',
            'formatter': 'default',
        },
    },
}
