#!/bin/sh

set -e


function process_log
{
    full_log_path="$1"

    IFS=$'\n'
    errors_count=($(
        fgrep 'ERROR' ${full_log_path} |
        fgrep -v 'Error occurred while processing account' |  # errors are duplicated in dbscripts error log
        wc -l |
        cut -d" " -f1
    ))
    errors=($(
        fgrep 'ERROR' ${full_log_path} |
          awk -F 'ERROR' '{ print $2; }' |
          sed -re 's/[^ ]* / /' |
          sed -re 's/POST args: .*/POST args: ***/' |
          sed -re 's/Request id: [^; ]+/Request_id: ***;/' |
          sed -re 's/user\/[0-9]+/user\/***/' |
          sed -re 's/seq=[0-9]+/seq=***/' |
          cut -c1-160 |
          fgrep -v 'Error occurred while processing account' |  # errors are duplicated in dbscripts error log
          sort |
          uniq -c |
          sort -rn
    ))
    if [[ -z "$errors" ]]; then
        echo -e "\e[32mOK        \e[0m\t${full_log_path}"
    else
        echo -e "\e[31mERROR ($errors_count)\e[0m\t${full_log_path}"
        for error in ${errors[*]}
        do
            echo $error
        done
    fi
    echo
}


DUTY_ENV=${DUTY_ENV:-production}
if [[ "$DUTY_ENV" == "test" ]]; then
    DUTY_ENV="testing"
fi
if [[ "$DUTY_ENV" != "production" && "$DUTY_ENV" != "testing" ]]; then
    DUTY_ENV="production"
fi

DUTY_DATE=${DUTY_DATE:-`date +%Y%m%d`}


OLD_ERROR_LOG_PATHS=(
    "passport-api/exception.log"
    "passport-db-scripts/exception.log"
    "passport-account-deleter/exception.log"
    "passport-adm-api/exception.log"
    "socialism/social-api.error.log"
    "socialism/social-broker.error.log"
    "socialism/social-proxy2.error.log"
    "socialism/social-utils.error.log"
    "passport-takeout/exception.log"
    "logbroker-client/takeout-tasks/exception.log"
    "perimeter/exception.log"
    "perimeter-api/exception.log"
    "passport-libs-checker/exception.log"
    "passport-tvm-keyring/exception.log"
)

# logstore 2.0
NEW_ERROR_LOG_PATHS_LOCALHOST=(
    "oauth-api/exception.log"
)
NEW_ERROR_LOG_PATHS_INTRANET=(
    "oauth-api/exception.log"
    "oauth-admin/exception.log"
    "tvm-api/exception.log"
)

for log_path in ${OLD_ERROR_LOG_PATHS[*]}
do
    process_log "/storage/$DUTY_ENV/var/log/yandex/${log_path}.${DUTY_DATE}"
done

for log_path in ${NEW_ERROR_LOG_PATHS_LOCALHOST[*]}
do
    process_log "/storage/logs/$DUTY_ENV/var/log/yandex/${log_path}.${DUTY_DATE}"

    if [[ "$DUTY_ENV" == "testing" ]]; then
        process_log "/storage/logs/rc/var/log/yandex/${log_path}.${DUTY_DATE}"
    fi
done

if [[ "$DUTY_ENV" != "testing" ]]; then
    for log_path in ${NEW_ERROR_LOG_PATHS_INTRANET[*]}
    do
        process_log "/storage/logs/$DUTY_ENV-intranet/var/log/yandex/${log_path}.${DUTY_DATE}"
    done
fi
