import json
import sys

import requests


def run_get_uids_by_logins():
    for login in sys.stdin:
        try:
            login = login.strip()
            if login:
                response = requests.get(
                    'http://blackbox-mimino.yandex.net/blackbox?method=userinfo&login={login}&userip=userip&format=json'.format(
                        login=login,
                    )
                )
                response = json.loads(response.text)
                print(response['users'][0]['uid']['value'])
        except Exception as e:
            print('Exception %s for login %s' % (e, login))
