from passport.backend.library.commander import Commander
from passport.backend.tools.everyday.ban_uids import (
    run_ban_uids,
    run_unban_uids,
)
from passport.backend.tools.everyday.get_uids_by_logins import run_get_uids_by_logins


def main():
    commander = Commander()
    commander.add_command(
        'get-uids-by-logins',
        run_get_uids_by_logins,
    )
    commander.add_command(
        'ban-uids',
        run_ban_uids,
    ).add_argument(
        '--comment', '-c',
        required=True,
        dest='comment',
        type=str,
    )
    commander.add_command(
        'unban-uids',
        run_unban_uids,
    ).add_argument(
        '--comment', '-c',
        required=True,
        dest='comment',
        type=str,
    )
    commander.invoke()
