#!/bin/sh

set -e

BASEDIR=$(dirname "$0")
WRAPPER="$BASEDIR/wrapper.sh"
LOGDIR="/storage/production/var/log/yandex/passport-api/graphite"
LOGNAME_PREFIX="graphite.log"
TMP_DIR="/storage/tmp/yandex_graphite_grants_reporter"
YT_PATH="//home/passport/production/reports/passport-api/grants"
YT_SCHEMA="$BASEDIR/yt_table.schema"

YT_OUTFILE="$TMP_DIR/yt.out"
YT_ERRFILE="$TMP_DIR/yt.err"
test -d "$TMP_DIR" || mkdir -p "$TMP_DIR"
# Make output files empty (: is true)
:> "$YT_OUTFILE"
:> "$YT_ERRFILE"

DATE="$1"
if [ -z "$DATE" ]; then
    DATE=$(date -d "-1 day" +'%Y%m%d')
else
    if ! echo "$DATE" | grep -E -q '^[0-9]{8}$'; then
        echo "Date format should be YYYYMMDD"
        exit 255
    fi
fi


YT_TABLE_NAME="$YT_PATH/graphite_grants_$DATE"
export YT_TOKEN="$(cat "$BASEDIR/yt.token")"

if [ "$(yt --proxy hahn exists "$YT_TABLE_NAME")" = "false" ]; then
    yt --proxy hahn create table "$YT_TABLE_NAME" >> $YT_OUTFILE 2>> $YT_ERRFILE
    yt --proxy hahn alter-table "$YT_TABLE_NAME" --schema "$(cat "$YT_SCHEMA")" >> $YT_OUTFILE 2>> $YT_ERRFILE
fi
yt --proxy hahn erase --table "$YT_TABLE_NAME" >> $YT_OUTFILE 2>> $YT_ERRFILE


$WRAPPER "$LOGDIR/$LOGNAME_PREFIX.$DATE"* | yt --proxy hahn write --format json --table "$YT_TABLE_NAME" >> $YT_OUTFILE 2>> $YT_ERRFILE
