# -*- coding: utf-8 -*-
import argparse
import logging
import os
import sys

import yenv


EXPECTED_POSTFIXES = {
    'localhost': {
        'development': ['development', 'localhost.development', 'testing', 'localhost.testing'],
        'testing': ['testing', 'localhost.testing'],
        'rc': ['rc', 'localhost.rc', 'production', 'localhost.production'],
        'production': ['production', 'localhost.production'],
    },
    'stress': {
        'stress': ['stress', 'stress.stress'],
    },
    'intranet': {
        'development': ['intranet.development', 'intranet.testing'],
        'testing': ['intranet.testing'],
        'rc': ['intranet.rc', 'intranet.production'],
        'production': ['intranet.production'],
    },
}


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('target_file_prefix', metavar='TARGET_FILE_PREFIX', help='File name (excluding environment suffix)')
    parser.add_argument('link_name', metavar='LINK_NAME', help='Resulting link name')
    return parser.parse_args()


def create_link(target_file_prefix, link_name):
    for postfix in EXPECTED_POSTFIXES[yenv.name][yenv.type]:
        target_file_name = '.'.join([target_file_prefix, postfix])
        if not os.path.isfile(target_file_name):
            continue
        if os.path.islink(link_name):
            os.unlink(link_name)
        elif os.path.isfile(link_name):
            os.remove(link_name)

        os.symlink(target_file_name, link_name)
        logging.info('Created symlink %s -> %s', link_name, target_file_name)
        return

    logging.error(
        'Failed to created symlink for %s: no config suitable for env_name=%s, env_type=%s',
        target_file_prefix,
        yenv.name,
        yenv.type,
    )
    sys.exit(1)


def main():
    logging.basicConfig(format='%(message)s', level=logging.INFO)
    args = parse_args()
    create_link(args.target_file_prefix, args.link_name)
