from http.server import (
    BaseHTTPRequestHandler,
    HTTPServer,
)
import json

from passport.backend.tools.metrics.io_utils import print_stderr


def format_metrics_for_golovan_pull(metrics, **kwargs):
    document = list(metrics.items())
    return json.dumps(
        document,
        indent=2,
        sort_keys=True,
    )


def aggregate_and_format_metrics_for_pull(metrics, tags):
    data = dict()
    for metric in metrics:
        data.update(metric.get_metrics())
    return format_metrics_for_golovan_pull(data, **tags)


class GolovanResponse(BaseHTTPRequestHandler):
    def log_message(self, format, *args):
        if self.server.debug:
            print_stderr(format % args)

    def do_GET(self):
        self.send_response(200)
        self.send_header('Content-type', 'application/json')
        self.wfile.write(
            aggregate_and_format_metrics_for_pull(
                self.server.metrics,
                self.server.golovan_settings).encode(),
        )
        if self.server.debug:
            print_stderr('Sent response')


class GolovanPull(HTTPServer):
    def __init__(self, host, port, metrics, golovan_settings, debug):
        super().__init__((host, port), GolovanResponse)
        self.metrics = metrics
        self.golovan_settings = golovan_settings
        self.debug = debug

    def start_server(self):
        if self.debug:
            print_stderr('Listening on {}:{}'.format(self.server_name, self.server_port))
        self.serve_forever()
