import http.client
import json
import socket
import urllib.parse

from passport.backend.tools.metrics.io_utils import print_stderr


def format_metrics_for_golovan_push(metrics, ttl=None, **kwargs):
    document = []
    for metric_name, metric_value in metrics.items():
        metric_data = {
            'tags': kwargs,
            'name': metric_name,
            'val': metric_value,
        }
        if ttl is not None:
            metric_data['ttl'] = int(ttl)
        document.append(metric_data)
    return json.dumps(
        document,
        indent=2,
        sort_keys=True,
    )


class GolovanPush(object):
    def __init__(self, url, debug_push, timeout=2):
        parsed_url = urllib.parse.urlparse(url, scheme='http://')
        self.host = parsed_url.netloc
        self.path = parsed_url.path
        self.timeout = timeout
        self.debug_push = debug_push

    def push_metrics(self, data):
        if self.debug_push:
            print_stderr('Connecting', str(self.host), 'timeout:', str(self.timeout))
        try:
            conn = http.client.HTTPConnection(self.host, timeout=self.timeout)
            conn.request('POST', self.path, data)
            rv = conn.getresponse()
            rv.read()
            rv.close()
        except (http.client.HTTPException, socket.error) as e:
            if self.debug_push:
                print_stderr(str(e))
        else:
            conn.close()

    def aggregate_and_push_metrics(self, metrics, tags):
        data = dict()
        for metric in metrics:
            data.update(metric.get_metrics())
        self.push_metrics(format_metrics_for_golovan_push(data, **tags))
