import errno
import sys


def print_stdout(*args):
    print_to_stream(sys.stdout, *args)


def print_stderr(*args):
    print_to_stream(sys.stderr, *args)


def print_to_stream(stream, *args):
    try:
        stream.write(' '.join(args) + '\n')
    except IOError as e:
        if e.errno == errno.EPIPE:
            pass
        raise
