from itertools import zip_longest


READ_BUFFER_SIZE = 100000


def grouper(iterable, n):
    args = [iter(iterable)] * n
    return ([i for i in item if i is not None] for item in zip_longest(*args) if item is not None)


def gather_metrics(input_stream, metrics_objs, aggregate=True, buffer_size=READ_BUFFER_SIZE):
    # Если за раз в память вычитать весь стрим и затем запустить несколько QB2.map,
    # то в памяти процесс занимает полгига при 1 000 000 строках лога.
    # Каждый раз открывать файл на чтение не выйдет, т.к. в скрипт будет подаваться
    # выхлоп какого нибудь tail'а, который не переоткроешь несколько раз.
    # Можно было бы читать поток построчно и вызывать QB2.map на каждую строчку,
    # но мне это интуитивно кажется контр-продуктивным. Чуйка говорит, что в QB2.map
    # лучше проваливаться пореже и наподольше (не проверял).
    # Поэтому буферизую чтение кусками, чтобы процесс не отъедал много памяти за раз.

    # Замеры памяти делал без валгриндов, а через time --verbose, грубым методом.
    # Maximum resident set size (kbytes): 109268
    for buff in grouper(input_stream, buffer_size):
        for metric in metrics_objs:
            metric.accumulate(buff)

    if aggregate:
        for metric in metrics_objs:
            for metric_name, value in metric.get_metrics():
                yield metric_name, value
