import io
import os
import time


def tail(filename):
    with open(filename, 'r', encoding='utf-8', errors='ignore') as f:
        try:
            f.seek(0, os.SEEK_END)
        except io.UnsupportedOperation:
            # seek не работает на named pipes
            pass
        f.readline()
        while True:
            for line in f:
                yield line.rstrip()
            time.sleep(0.2)
