import threading


class PerpetualTimer(object):
    def __init__(self, interval, function, args, kwargs, name=None):
        self.interval = interval
        self.function = function
        self.args = args
        self.kwargs = kwargs
        self.name = name
        self.timer = None

        self.mk_timer()

    def mk_timer(self):
        self.timer = threading.Timer(
            interval=self.interval,
            function=self.tick,
        )
        self.timer.daemon = True
        self.timer.name = self.name

    def start(self):
        self.timer.start()

    def tick(self):
        self.mk_timer()
        self.start()

        self.function(*self.args, **self.kwargs)
