#!/bin/bash

EMAIL="passport-stats@yandex-team.ru"
CC_EMAILS="eugene311@yandex-team.ru
kmerenkov@yandex-team.ru
andrey1931@yandex-team.ru"

CC_EMAIL=$(echo "${CC_EMAILS}" | awk -v seed="${RANDOM}" 'BEGIN { srand(seed); } { print rand(), $1; }' | sort -n | head -n 1 | awk '{ print $NF; }')

DATE=`date -d '1 day ago' '+%Y-%m-%d'`
DATE_LOG=`date -d '1 day ago' '+%Y%m%d'`

PYERRORS=$(fgrep -B 1 'ERROR' "/storage/production/var/log/yandex/passport-api/exception.log.${DATE_LOG}" | awk -F 'ERROR' '{ print $2; }' | sed -re 's/(.*_HTTPSConnectionPool[^\/]+)(\/[^ ]+)(.*)/\1***\3/g' | fgrep -v 'DOCTYPE HTML PUBLIC' | sort | uniq -c | sort -rn)
PYWARN=$(fgrep -e 'WARNING' -e 'ERROR' "/storage/production/var/log/yandex/passport-api/warning.log.${DATE_LOG}" | awk '{ print $5; }' | sort | uniq -c | fgrep -e 'api' -e 'passport' | sort -rn)
PYERRORSTEST=$(fgrep -B 1 'ERROR' "/storage/testing/var/log/yandex/passport-api/exception.log.${DATE_LOG}" | awk -F 'ERROR' '{ print $2; }' | sed -re 's/(.*_HTTPSConnectionPool[^\/]+)(\/[^ ]+)(.*)/\1***\3/g' | sort | uniq -c | sort -rn)
PYWARNTEST=$(fgrep -e 'WARNING' -e 'ERROR' "/storage/testing/var/log/yandex/passport-api/warning.log.${DATE_LOG}" | awk '{ print $5; }' | sort | uniq -c | fgrep -e 'api' -e 'passport' | sort -rn)

RESULT=""

if [ -n "${PYERRORS}" ]; then
    RESULT="== PYERRORS ==

${PYERRORS}
"
fi

if [ -n "${PYWARN}" ]; then
    RESULT="${RESULT}

== PYWARN ==

${PYWARN}
"
fi

if [ -n "${PYERRORSTEST}" ]; then
    RESULT="${RESULT}

== PYERRORTEST ==

${PYERRORSTEST}
"
fi

if [ -n "${PYWARNTEST}" ]; then
    RESULT="${RESULT}

== PYWARNTEST ==

${PYWARNTEST}
"
fi

if [ -n "${RESULT}" ]; then
    RESULT="Привет!

Отчет по задаче PASSP-14980 за ${DATE}
<https://st.yandex-team.ru/PASSP-14980>

${RESULT}

--
Вы получили данное письмо т.к. дали свое согласие на получение рассылки в тикете PASSP-14980.
"
    echo "${RESULT}" | /usr/bin/bsd-mailx                          \
        -a "Mime-Version: 1.0"                                     \
        -a "Content-Type: text/plain; charset=UTF-8"               \
        -a "Content-Transfer-Encoding: 8bit"                       \
        -a "Refrences: <20171128144009.31042a97@yandex-team.ru>"   \
        -a "In-Reply-To: <20171128144009.31042a97@yandex-team.ru>" \
        -s "[${DATE}] Отчет по задаче PASSP-14980"                 \
        -c "${CC_EMAIL}"                                           \
        "${EMAIL}"
fi
