import datetime
import glob
import re
import sys


def float_value(val):
    try:
        return float(val)
    except Exception:
        return -1.0


def report(data):
    cnt_sum = 0
    cum_sum = 0.0

    for item in data:
        cnt_sum += item[1]
        cum_sum += item[2]

    data.sort(key=lambda x: x[2], reverse=True)

    print(" count (%)  cum (%) /  avg      url")
    for item in data:
        cnt_pct = float(item[1] * 100) / float(cnt_sum)
        cum_pct = item[2] * 100.0 / cum_sum
        if cnt_pct >= 1.0 or cum_pct >= 1.0 or item[3] >= 1.0:
            url = item[0].replace("#", "?")
            print("  {0:>5.2f}%     {1:>5.2f}% / {2:>4.3f}     {3}".format(cnt_pct, cum_pct, item[3], url))


def parse(log, date, replaces, data):
    search = "{0}.{1}*".format(log, date.strftime("%Y%m%d"))
    for name in glob.glob(search):
        for line in open(name):
            parts = line.strip().split()
            if len(parts) <= 10:
                continue

            time = float_value(parts[6])
            if time <= 0 or time >= 30:
                continue

            url = parts[10].strip()
            if not url.startswith("/"):
                continue

            for pattern, replace_value in replaces:
                url = re.sub(pattern, replace_value, url)

            url_stats = data.get(url, [url, 0, 0.0, 0.0])

            i = url_stats[1] + 1
            url_stats[1] = i
            url_stats[2] += time
            url_stats[3] = float(i - 1) / float(i) * url_stats[3] + time / float(i)

            data[url] = url_stats


def main():
    backend_data = {}
    frontend_data = {}
    sso_data = {}

    backend_replaces = [
        ["passport\\?mode=", "passport#mode="],
        ["((\\?|&).+$)", ""],
        ["/account/[0-9]+/", "/account/???/"],
        ["/subscription/[0-9a-zA-Z_.-]+/", "/subscription/???/"],
        ["/track/[0-9a-f]+/", "/track/???/"],
        ["/pddalias/[0-9a-zA-Z@_.-]+/", "/pddalias/???/"],
        ["/domain/[0-9]+/", "/domain/???/"],
        ["/alias/[0-9]+/", "/alias/???/"],
        ["/1/bundle/plus/[0-9]+", "/1/bundle/plus/???"],
        ["/$", ""],
    ]

    frontend_replaces = [
        ["passport\\?mode=", "passport#mode="],
        ["/profile/social/[0-9]+", "/profile/social/???"],
        ["/profile/subscriptions/[0-9]+", "/profile/subscriptions/???"],
        ["/profile/family/invite/[a-f0-9-]+", "/profile/family/invite/???"],
        ["((\\?|&).+$)", ""],
        ["/$", ""],
    ]

    sso_replaces = [
        ["((\\?|&).+$)", ""],
        ["/$", ""],
    ]

    for item in backend_replaces:
        item[0] = re.compile(item[0])

    for item in frontend_replaces:
        item[0] = re.compile(item[0])

    for item in sso_replaces:
        item[0] = re.compile(item[0])

    yesterday = datetime.datetime.now() - datetime.timedelta(days=1)

    parse_args = [
        ("/storage/production/var/log/nginx/passport-internal.access.log", yesterday, backend_replaces, backend_data),
        ("/storage/production/var/log/nginx/passport.access.log", yesterday, frontend_replaces, frontend_data),
        ("/storage/production/var/log/nginx/sso.access.log", yesterday, sso_replaces, sso_data),
    ]
    for args in parse_args:
        parse(*args)

    print("Привет!")
    print("")
    print("Отчет по временам ответа ручек паспорта за " + yesterday.strftime("%Y-%m-%d"))
    print("(количество вызовов >= 1%, или суммарное время >= 1%, или среднее время >= 1s)")
    print("")
    print("= backend =")
    print("")

    report(list(backend_data.values()))

    print("")
    print("")

    print("= frontend =")
    print("")

    report(list(frontend_data.values()))

    print("")
    print("")
    print("= sso =")
    print("")

    report(list(sso_data.values()))

    print("")
    print("-- ")
    print("logstore-s1.passport.yandex.net:/opt/scripts/PASSP-TIME.sh")
