## Шардушка
Утилита генерит конфиги шардирования для ЧЯ, питонячьего паспорта (passport-api, dbscripts, adm-api, etc) и перлового паспорта (в т.ч. перловой админки).

### Терминология
1. `Shard` (шард) - часть БД (мастер + слейвы), хранящая часть данных. Данные распределяются по шардам по некоторому признаку (в данном случае по uid)
2. `Rangeset` (множество диапазонов) - набор диапазонов шардирования, объединённых общей логикой формирования.
3. `Range` (диапазон) - диапазон шардирования, инструкция вида "уиды от сих до сих клади в такой-то шард".

### Базовый сценарий
1. Внести правки в код утилиты и/или скрипты `bin/create_*`
2. Запустить `bin/create_all.sh && bin/export_all.sh`
3. Закоммитить результат (в том числе `conf/*` и `export/*`) для потомков
4. Взять результат `export/passport_pl/*` и унести в конфиги перловой админки. (Конфиги остальных сервисов утилита сразу кладёт в нужные места)
5. Пересобрать и перевыкатить сервисы, никого не забыв

### Продвинутые сценарии
Запустить утилиту `bin/shardushka` с нужными параметрами.

1. `shardushka init --config <name>` создаёт чистый конфиг с указанным именем
2. `shardushka create * --config <name>` вносит правки, которые фиксируются в этом конфиге
3. `shardushka export --format <format> --config <name>` выводит конфиг шардирования в указанном формате
