#!/bin/bash

set -eu -o pipefail

DIR_SRC=$(cd $(dirname $0)/..; pwd)
cd $DIR_SRC

bin/shardushka --config conf/prod.json init

bin/shardushka --config conf/prod.json create shard --id 1
bin/shardushka --config conf/prod.json create shard --id 2
bin/shardushka --config conf/prod.json create shard --id 3
bin/shardushka --config conf/prod.json create shard --id 4

bin/shardushka --config conf/prod.json create rangeset --name normal    --min 0                     --shard 1
bin/shardushka --config conf/prod.json create rangeset --name normal2   --min 1_392_100_000         --shard 1  # зазор в 100к от прошлого rangeset
bin/shardushka --config conf/prod.json create rangeset --name kinopoisk --min 1110000000000000      --shard 1
bin/shardushka --config conf/prod.json create rangeset --name pdd       --min 1130000_000_000_000   --shard 1
bin/shardushka --config conf/prod.json create rangeset --name pdd2      --min 1130000_051_300_000   --shard 1  # зазор в 100к от прошлого rangeset

bin/shardushka --config conf/prod.json create ranges --rangeset normal    --limit 1_392_000_000 --lap-capacity 4_000_000 --shares 28,28,22,22
bin/shardushka --config conf/prod.json create ranges --rangeset normal2   --limit 3_608_000_000 --lap-capacity 4_000_000 --shares 18,18,32,32
bin/shardushka --config conf/prod.json create ranges --rangeset kinopoisk --limit   100_000_000 --lap-capacity   400_000 --shares 28,28,22,22
bin/shardushka --config conf/prod.json create ranges --rangeset pdd       --limit    51_200_000 --lap-capacity   400_000 --shares 28,28,22,22
bin/shardushka --config conf/prod.json create ranges --rangeset pdd2      --limit   148_800_000 --lap-capacity   400_000 --shares 25,25,25,25
