#!/bin/bash

set -eu -o pipefail

DIR_SRC=$(cd "$(dirname $0)/.."; pwd)
cd "${DIR_SRC}"

DIR_DST=$(cd "${DIR_SRC}/../../api/settings/sharding"; pwd)

DEVELOPMENT=`bin/shardushka --config conf/dev.json export --format passport_py`
TESTING=`bin/shardushka --config conf/test.json export --format passport_py`
PRODUCTION=`bin/shardushka --config conf/prod.json export --format passport_py`
TEAM=`bin/shardushka --config conf/team.json export --format passport_py`
TEAMTEST=`bin/shardushka --config conf/team-test.json export --format passport_py`

cat >"${DIR_DST}/ranges.py" <<EOF
# -*- coding: utf-8 -*-
# Конфиг сгенерирован с помощью https://a.yandex-team.ru/arc_vcs/passport/backend/tools/shardushka
DB_SHARDING_RANGES = {
    'other': {
        'development': $DEVELOPMENT,
        'testing': $TESTING,
        'production': $PRODUCTION,
    },
    'stress': {
        'stress': $TESTING,
    },
    'intranet': {
        'development': [],
        'testing': $TEAMTEST,
        'production': $TEAM,
    },
}

DB_SHARDING_RANGES['other']['rc'] = DB_SHARDING_RANGES['other']['production']
DB_SHARDING_RANGES['intranet']['rc'] = DB_SHARDING_RANGES['intranet']['production']
EOF
