# -*- coding: utf-8 -*-


class Range:
    def __init__(self, shard_id, min_uid, max_uid=None):
        self.shard_id = shard_id
        self.min_uid = min_uid
        self.max_uid = max_uid

    def as_dict(self):
        return {
            'min': self.min_uid,
            'max': self.max_uid,
            'shard': self.shard_id,
        }

    def __repr__(self):
        return '<{} ({}-{}, shard {})>'.format(
            self.__class__.__name__,
            self.min_uid,
            self.max_uid or '∞',
            self.shard_id,
        )
