# -*- coding: utf-8 -*-


class RangeSet:
    def __init__(self, name):
        self._name = name
        self._ranges = []

    def last_range(self):
        if not self._ranges:
            return
        return self._ranges[-1]

    def append(self, range_):
        last = self.last_range()
        if last is not None:
            assert range_.min_uid > last.min_uid
            last.max_uid = range_.min_uid - 1
        self._ranges.append(range_)

    def __iter__(self):
        return iter(self._ranges)

    def __repr__(self):
        return '<{} (`{}`, {} ranges)>'.format(
            self.__class__.__name__,
            self._name,
            len(self._ranges),
        )
