# -*- coding: utf-8 -*-
from passport.backend.core.builders.abc import ABC


class ABCHelper(object):
    def __init__(self, oauth_token):
        self.abc_client = ABC(
            url='https://abc-back.yandex-team.ru/api/',
            timeout=3,
            retries=3,
        )
        self.oauth_token = oauth_token

    def get_abc_members(self, abc_service, abc_scope=None):
        filter_args = dict(
            service__slug=abc_service,
            fields=['person.login'],
        )
        if abc_scope is not None:
            filter_args.update(role__scope=abc_scope)

        rv = self.abc_client.get_service_members(
            filter_args=filter_args,
            oauth_token=self.oauth_token,
        )
        return [
            item['person']['login']
            for item in rv
        ]
