import argparse
import os
import subprocess
import sys


UID_LIMIT = 500
MYSQL_CONFIG = '/usr/lib/yandex/takeout-errors-reporter/adminka_ro.conf'


def run_sql(host, db, sql):
    return subprocess.check_output(
        ['/usr/bin/mysql', '--defaults-extra-file={0}'.format(MYSQL_CONFIG), '-h', host, '-D', db, '-se', sql],
        stderr=subprocess.STDOUT,
        encoding='utf-8',
    ).strip()


def run():
    parser = argparse.ArgumentParser()
    parser.add_argument('--limit', default=UID_LIMIT, required=False, type=int)
    args = parser.parse_args()

    HOSTNAME = os.uname()[1]
    if HOSTNAME == 'adm-test.yandex-team.ru':
        ENV_NAME = 'Takeout (testing)'
        DB_MAP = {'cnt-dbs-test-adm-m1.passport.yandex.net': ['passportdbshard1', 'passportdbshard2']}
    elif HOSTNAME == 'webadmin-m1.passport.yandex.net':
        ENV_NAME = 'Takeout (production)'
        DB_MAP = {
            'sh1-dbs-adm-m1.passport.yandex.net': ['passportdbshard1'],
            'sh2-dbs-adm-m1.passport.yandex.net': ['passportdbshard2'],
            'sh3-dbs-adm-m1.passport.yandex.net': ['passportdbshard3'],
            'sh4-dbs-adm-m1.passport.yandex.net': ['passportdbshard4'],
        }
    else:
        sys.exit(0)

    if not os.path.isfile(MYSQL_CONFIG):
        sys.exit(1)

    count_running = 0
    count_failed = 0
    failed_uids = []

    for host, shards in DB_MAP.items():
        for shard in shards:
            count_running += int(run_sql(host, shard, 'SELECT COUNT(1) FROM `searchable_attributes` WHERE `type` = 173'))
            count_failed += int(
                run_sql(
                    host,
                    shard,
                    'SELECT COUNT(1) FROM `searchable_attributes` WHERE `type` = 173 AND `value` < UNIX_TIMESTAMP()',
                ),
            )
            failed_uids_T = run_sql(
                host,
                shard,
                'SELECT `uid` FROM `searchable_attributes` WHERE `type` = 173 AND `value` < UNIX_TIMESTAMP() LIMIT {0}'.format(
                    args.limit,
                ),
            ).split("\n")
            for uid in failed_uids_T:
                if len(uid):
                    failed_uids.append(uid)

    failed_uids = list(set(failed_uids))
    SUBJECT = '<OK> {0}'.format(ENV_NAME)
    MESSAGE = "Extracts currently running: {0}\n".format(count_running)
    if count_failed > 0:
        SUBJECT = '[{0} failed] <ERROR> {1}'.format(count_failed, ENV_NAME)
        MESSAGE += "\nExtracts that have probably failed: {0}. Uids (not more than first {1}):\n{2}".format(
            count_failed, args.limit, "\n".join(failed_uids),
        )

    r, w = os.pipe()
    os.write(w, MESSAGE.encode('utf-8'))
    os.close(w)

    subprocess.check_call(
        [
            '/usr/bin/bsd-mailx',
            '-a',
            'Mime-Version: 1.0',
            '-a',
            'Content-Type: text/plain; charset=UTF-8',
            '-a',
            'Content-Transfer-Encoding: 8bit',
            '-s',
            SUBJECT,
            'passport-stats@yandex-team.ru',
        ],
        stdin=r,
        stderr=subprocess.STDOUT,
    )
