# -*- coding: utf-8 -*-
from datetime import (
    datetime,
    timedelta,
)
import os
import random

from library.python.vault_client.instances import Production
import requests
from yt.wrapper.client import YtClient


DRY_RUN = True

SUP_URL = 'https://sup.yandex.net/pushes'
SUP_DRY_RUN_URL = 'https://sup.yandex.net/pushes?dry_run=1'

PP_NOT_LOGGED_IN_DIR = '//home/exp-search/sanaumenko/zalogin/zalogin-50'
PP_NOT_LOGGED_IN_TABLE_NAME_TEMPLATE = 'pp_notzalogin_%s'  # 2019-08-11

SUCCESSFUL_PUSHES_DIR = '//home/passport/arhibot/zalogin_push'
PUSH_FREQ_DAYS = 30
PUSH_PER_DAY = 1

PUSH_CONFIG = u'''{
  "receiver": [
    "yt:%s? lang=='ru' && app_version_code >= 5010000 && !uid && app_id IN ('ru.yandex.searchplugin', 'ru.yandex.searchplugin.beta', 'ru.yandex.searchplugin.nightly', 'ru.yandex.searchplugin.dev')\
 &&  theme != pp_feature_recommendation_push_off"
  ],
  "schedule": "now",
  "ttl": 86400,
  "notification": {
    "title": "Войдите в свой аккаунт",
    "body": "Так Яндекс будет лучше понимать вас"
  },
  "data": {
      "push_id": "from_passport-push",
      "push_uri": "ya-search-app-open://?uri=yandex-auth://source=serp_zalogin_push",
      "push_action": " uri",
      "topic_push": "pp_feature_recommendation_push"
  },
  "project": "zalogin"
  "android_features": {
    "ledType": 1,
    "soundType": 1
  },
  "ios_features": {
    "soundType": 1
  }
}'''


def get_yt_client():
    return YtClient(
        proxy='hahn',
        token=Production().get_version('sec-01cw63q068d7ywsbf0a5pwdxks')['value']['yt_token'],
    )


def download_pp_active_not_logged_in_users(yt_client, date):
    yt_pp_users_table = os.path.join(
        PP_NOT_LOGGED_IN_DIR,
        PP_NOT_LOGGED_IN_TABLE_NAME_TEMPLATE % date.strftime('%Y-%m-%d')
    )
    rows = yt_client.read_table(yt_pp_users_table)
    uuids = []
    count = 0
    for row in rows:
        if row['active'] == 1 and row['zalogin'] == 0 and row['app_platform'] == 'Android':
            uuids.append(row['uuid'])
            count += 1
        if count > 1000:
            break
    return set(uuids)


def download_already_sent_uuids(yt_client, from_date, to_date):
    date_range = [
        from_date + timedelta(days=i)
        for i in xrange(0, (to_date - from_date).days)
    ]
    uuids = []
    for date in date_range:
        sent_at_day_table = os.path.join(SUCCESSFUL_PUSHES_DIR, date.strftime('%Y-%m-%d'))
        if not yt_client.exists(sent_at_day_table):
            continue
        rows = yt_client.read_table(sent_at_day_table)
        for row in rows:
            uuids.append(row['uuid'])
    return set(uuids)


def send_table_to_sup(table):
    print('Sending table %s to SUP' % table)
    actual_config = PUSH_CONFIG % table
    print(actual_config)
    sup_token = Production().get_version('sec-01dj5aww56ajrcq4exqsdtc98d')['value']['sup_token']
    response = requests.post(
        SUP_DRY_RUN_URL if DRY_RUN else SUP_URL,
        headers={
            'Content-Type': 'application/json;charset=UTF-8',
            'Authorization': 'OAuth %s' % sup_token,
        },
        data=actual_config,
    )
    print('Sent result: ', response.content)


def send_zalogin_push_to_pp():
    yt_client = get_yt_client()
    today = datetime.today() - timedelta(days=1)

    already_sent_uuids = download_already_sent_uuids(
        yt_client,
        today - timedelta(days=PUSH_FREQ_DAYS),
        today,
    )
    print('Already sent: ', len(already_sent_uuids))
    yesterday_active_users = download_pp_active_not_logged_in_users(yt_client, today - timedelta(days=1))
    print('Total active users:', len(yesterday_active_users))

    uuids_for_sending = yesterday_active_users - already_sent_uuids
    print('Total users for sending:', len(uuids_for_sending))

    uuids_for_sending = list(uuids_for_sending)
    random.shuffle(uuids_for_sending)

    actual_pushes_table = os.path.join(SUCCESSFUL_PUSHES_DIR, today.strftime('%Y-%m-%d'))
    if yt_client.exists(actual_pushes_table):
        print('Table %s already exists' % actual_pushes_table)
        return

    yt_client.write_table(
        actual_pushes_table,
        ({'uuid': x} for x in uuids_for_sending[:PUSH_PER_DAY]),
    )
    send_table_to_sup(actual_pushes_table)
