class BaseError(Exception):
    pass


class BaseTVMError(BaseError):
    """Ошибка запроса к TVM"""


class TVMTemporaryError(BaseTVMError):
    """Временная ошибка запроса к TVM, стоит поретраиться"""


class TVMPermanentError(BaseTVMError):
    """Пятисотка или непредвиденная ошибка запроса к TVM"""


class ConfigInvalidError(BaseError):
    """Конфиг имеет недопустимый формат"""


class ResultInvalidError(BaseError):
    """Файл с результатом отсутствует или невалиден"""


class ResultOutdatedError(BaseError):
    """Файл с результатом сильно устарел"""


class ResultExpiresSoonError(ResultOutdatedError):
    """Файл с результатом близок к устареванию"""


class ResultIncompleteError(BaseError):
    """Файл с результатом содержит не все нужные данные"""
