import argparse
from logging.config import dictConfig

from passport.backend.tvm_keyring import settings
from passport.backend.tvm_keyring.update import update
from passport.backend.tvm_keyring.validate import validate


MODE_UPDATE = 'update'
MODE_VALIDATE = 'validate'


def main():
    parser = argparse.ArgumentParser(description='Get and dump to disk TVM keys and tickets')
    parser.add_argument('mode', choices=[MODE_UPDATE, MODE_VALIDATE], help='action to run')
    parser.add_argument('-f', '--force', action='store_true', help='reissue tickets even if they seem to be actual')
    parser.add_argument('-v', '--verbose', action='store_true', help='give more output')

    args = parser.parse_args()

    log_settings = settings.LOGGING.copy()
    if args.verbose:
        log_settings['root']['handlers'].append('console')  # pragma: no cover
    dictConfig(settings.LOGGING)

    if args.mode == MODE_UPDATE:
        update(force=args.force)
    elif args.mode == MODE_VALIDATE:
        print(validate())
