import os

import yenv


_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

IS_UNDER_TESTS = os.environ.get('YA_MAKE_T', os.environ.get('YA_TEST_RUNNER'))
DEBUG = IS_UNDER_TESTS or (yenv.type == 'development' and _current_user not in ('root', 'www-data'))


CONFIG_PATH = '/etc/yandex/passport-tvm-keyring/conf-enabled/'
SECRET_CONFIG_PATH = '/etc/yandex/passport-tvm-keyring/secrets/'
RESULT_PATH = '/var/cache/yandex/passport-tvm-keyring/'
if DEBUG:
    CONFIG_PATH = 'test_data/configs/'
    SECRET_CONFIG_PATH = 'test_data/secrets/'
    RESULT_PATH = 'test_data/results/'


TVM_URL = 'https://tvm-api.yandex.net'
TVM_TIMEOUT = 1
TVM_RETRIES = 3


# Минимальные интервалы между подновлениями ключей и тикетов
KEYS_UPDATE_INTERVAL = 23 * 3600
TICKETS_UPDATE_INTERVAL = 3600

# Давность ключей и тикетов, при достижении которой зажжётся мониторинг
MAX_KEYS_AGE_WARN = 25 * 3600
MAX_TICKETS_AGE_WARN = 3 * 3600

MAX_KEYS_AGE_CRIT = 49 * 3600
MAX_TICKETS_AGE_CRIT = 8 * 3600


RESULT_TICKETS_DEFAULT_PERMISSIONS = 0o644 if yenv.type == 'development' else 0o600
RESULT_TICKETS_DEFAULT_OWNER = 'www-data'
RESULT_TICKETS_DEFAULT_GROUP = 'www-data'

RESULT_KEYS_PERMISSIONS = 0o644
RESULT_KEYS_OWNER = RESULT_TICKETS_DEFAULT_OWNER
RESULT_KEYS_GROUP = RESULT_TICKETS_DEFAULT_GROUP


# TODO: выкинуть, когда библиотека не станет их требовать
FAKE_CLIENT_ID = 0
FAKE_CLIENT_SECRET = 'A' * 22  # 16 нулевых байт в base64url

SSL_CA_CERT = '/etc/ssl/certs/ca-certificates.crt'


LOG_PATH = '' if DEBUG else '/var/log/yandex/passport-tvm-keyring/'


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '%(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'simple': {
            'format': '%(levelname)-10s %(message)s',
        },
    },
    'root': {
        'handlers': ['debug', 'warning'],
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'simple',
        },
        'debug': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'debug.log',
            'formatter': 'default',
            'level': 'DEBUG',
        },
        'warning': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'warning.log',
            'formatter': 'default',
            'level': 'WARNING',
        },
        'exception': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'exception.log',
            'level': 'ERROR',
        },
    },
    'loggers': {
        # Логгер для сторонней библиотеки requests
        'requests': {
            'handlers': ['warning', 'exception'],
            'level': 'WARNING',
            'propagate': False,
        },
    },
}


if IS_UNDER_TESTS:
    LOGGING = {'version': 1, 'disable_existing_loggers': True}
