package main

import (
	"encoding/json"
	"io/ioutil"
	"log"
	"net/http"
	"os"
)

type TankerResponse struct {
	Keysets TankerKeysets `json:"keysets"`
}

type TankerKeysets struct {
	ContactsDivCards ContactsDivCards `json:"ContactsDivCards"`
}

type ContactsDivCards struct {
	Keys map[string]TankerKeyData `json:"keys"`
}

type TankerKeyData struct {
	Translations map[string]TankerTranslation `json:"translations"`
}

type TankerTranslation struct {
	Form string `json:"form"`
}

func main() {
	resp, err := http.Get("https://tanker-api.yandex-team.ru/keysets/tjson/?keyset-id=ContactsDivCards&project-id=passport&safe=1")
	if err != nil {
		log.Fatalln(err)
		os.Exit(1)
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		log.Fatalln(err)
		os.Exit(1)
	}
	var tr TankerResponse
	err = json.Unmarshal(body, &tr)
	if err != nil {
		log.Fatalln(err)
		os.Exit(1)
	}
	languages := []string{"ru", "en"}
	output := make(map[string]map[string]string)
	for _, language := range languages {
		output[language] = make(map[string]string)
		for key, data := range tr.Keysets.ContactsDivCards.Keys {
			translation := data.Translations[language].Form
			output[language][key] = translation
		}
	}
	file, _ := json.MarshalIndent(output, "", "  ")
	file = append(file, '\n')
	err = ioutil.WriteFile("../translations.json", file, 0644)
	if err != nil {
		log.Fatalln(err)
		os.Exit(1)
	}
}
