package translations

import (
	_ "embed"
	"encoding/json"
)

type TranslationsCache struct {
	data map[string]map[string]string
}

//go:embed translations.json
var translations []byte

func NewTranslationsCache() (*TranslationsCache, error) {
	data := make(map[string]map[string]string)
	data["ru"] = make(map[string]string)
	data["en"] = make(map[string]string)

	err := json.Unmarshal(translations, &data)
	if err != nil {
		return nil, err
	}
	return &TranslationsCache{data: data}, nil
}

func (tc *TranslationsCache) Get(lang string, key string) string {
	return tc.data[lang][key]
}
