package uaasproxy

import (
	"bytes"
	"io/ioutil"
	"math/rand"
	"net/http"
	"time"
)

type HTTPApiClient struct {
	Client  *http.Client
	BaseURL string
}

func GetDefaultUaasClient(uaasURL string) HTTPApiClient {
	var uaasClient = &http.Client{
		Timeout: time.Millisecond * 500,
		// отключает следование по редиректам
		CheckRedirect: func(req *http.Request, via []*http.Request) error {
			return http.ErrUseLastResponse
		},
	}
	return HTTPApiClient{uaasClient, uaasURL}
}

func GetFakeUaasClient(sleepDuration int, sleepJitter int) HTTPApiClient {
	// для бенчмарка
	headers := make(http.Header)
	headers.Set("X-Yandex-ExpBoxes", "182998,0,-1;176965,0,-1")
	headers.Set("X-Yandex-ExpFlags", "W3siSEFORExFUiI6IlBBU1NQT1JUIiwiQ09OVEVYVCI6eyJQQVNTUE9SVCI6eyJmbGFncyI6WyJzaG93LXN1YnNjcmlwdGlvbnMiXX19fV0=,W3siSEFORExFUiI6IlBBU1NQT1JUIiwiQ09OVEVYVCI6eyJQQVNTUE9SVCI6eyJmbGFncyI6WyJkb21pay1jaGFsbGVuZ2UtZXhwIl19fX1d")

	MockClient := HTTPApiClient{
		Client: NewTestClient(func(req *http.Request) (*http.Response, error) {
			if sleepDuration > 0 {
				rand.Seed(time.Now().UnixNano())
				n := sleepDuration
				if sleepJitter > 0 {
					n += rand.Intn(sleepJitter)
				}
				time.Sleep(time.Duration(n) * time.Millisecond)
			}
			return &http.Response{
				StatusCode: http.StatusOK,
				Body:       ioutil.NopCloser(bytes.NewBufferString("USERSPLIT")),
				Header:     headers,
			}, nil
		}),
		BaseURL: "https://test-domain",
	}
	return MockClient
}
