package uaasproxy

type RewriteExperimentsExpression struct {
	MatchKeyValue map[string]string
	FlagsToAdd    []string
	FlagsToRemove []string
}

var RewriteConfig = []RewriteExperimentsExpression{}

func InitRewriteConfig() {
	RewriteConfig = RewriteConfig[:0]
	RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
		// нужды тестирования
		MatchKeyValue: map[string]string{
			"app_id": "testpers",
		},
		FlagsToAdd: []string{"hello_testpers"},
	})
	RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
		// нужды тестирования 2
		MatchKeyValue: map[string]string{
			"app_id":     "unit-tests",
			"am_version": "unit-tests",
		},
		FlagsToAdd: []string{"hello-unit-tests"},
	})
	// PASSP-28471
	lavkaAppIds := []string{
		// Android
		"com.yandex.lavka",
		"com.yandex.lavka.beta",
		"com.yandex.lavka.develop",
		"com.yandex.lavka.debug",
		// iOS
		"ru.yandex.lavka",
		"ru.yandex.lavka.inhouse",
		"ru.yandex.lavka.develop",
	}
	for _, lavkaAppID := range lavkaAppIds {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": lavkaAppID,
			},
			FlagsToAdd:    []string{"turn_neophonish_reg_on=1"},
			FlagsToRemove: []string{"reg_call_confirm_on=1"},
		})
	}
	// PASSP-29345
	neophonishAppIDs := []string{
		// Both platforms
		"ru.kinopoisk",
		// Android
		"com.edadeal.android",
		"com.yandex.browser",
		"com.yandex.mobile.realty",
		"com.yandex.zen",
		"ru.yandex.music",
		"ru.yandex.searchplugin",
		"ru.yandex.yandexmaps",
		"ru.yandex.yandexnavi",
		"ru.beru.android",
		// iOS
		"com.s-g-i.Edadeal",
		"ru.yandex.mobile.navigator",
		"ru.yandex.mobile.realty",
		"ru.yandex.blue.market",
	}
	for _, neophonishAppID := range neophonishAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": neophonishAppID,
			},
			FlagsToAdd: []string{"turn_neophonish_reg_on=1"},
		})
	}
	// PASSP-30575, PASSP-30576, PASSP-33673
	yangodeliAppIDsAndroid := []string{
		// Android
		"com.yandex.yangodeli",
		"com.yandex.yangodeli.debug",
		"com.yandex.yangodeli.develop",
		"com.yandex.yangodeli.beta",
	}
	for _, yangodeliAppID := range yangodeliAppIDsAndroid {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": yangodeliAppID,
			},
			FlagsToAdd: []string{"turn_neophonish_reg_on=1", "turn_superlite_reg_on=0", "web_am_on=1", "turn_mailing_accept_on=0", "native_to_browser_exp=0"},
		})
	}
	yangodeliAppIDsiOS := []string{
		// iOS
		"ru.yandex.yangodeli",
		"ru.yandex.yangodeli.inhouse",
		"ru.yandex.yangodeli.develop",
	}
	for _, yangodeliAppID := range yangodeliAppIDsiOS {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": yangodeliAppID,
			},
			FlagsToAdd: []string{"turn_neophonish_reg_on=1", "turn_superlite_reg_on=0", "web_login_on=1", "turn_mailing_accept_on=0", "native_to_browser_exp=0"},
		})
	}
	// PASSP-30615
	edaAppIDs := []string{
		// Android
		"ru.foodfox.client",
		// iOS
		"com.appkode.foodfox",
	}
	for _, edaAppID := range edaAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": edaAppID,
			},
			FlagsToAdd: []string{"turn_neophonish_reg_on=1"},
		})
	}
	// PASSP-30961, PASSP-30762
	taxiAppIDs := []string{
		// Android
		"ru.yandex.taxi",
		"ru.yandex.taxi.debug",
		"ru.yandex.taxi.beta",
		// iOS
		"ru.yandex.ytaxi",
		"ru.yandex.taxi.inhouse",
		// both
		"ru.yandex.taxi.develop",
	}
	for _, taxiAppID := range taxiAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": taxiAppID,
			},
			FlagsToAdd: []string{"turn_neophonish_reg_on=1", "native_to_browser_exp=0"},
		})
	}
	// PASSP-31218
	mapsAppIDs := []string{
		"ru.yandex.traffic",
		"ru.yandex.traffic.sandbox",
		"ru.yandex.traffic.inhouse",
	}
	for _, mapsAppID := range mapsAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": mapsAppID,
			},
			FlagsToAdd: []string{"turn_neophonish_reg_on=1"},
		})
	}
	// PASSP-32736
	accountManagerVersions := []string{
		"7.18.0(718001930)",
		"7.18.1(718011943)",
		"7.19.0(719002012)",
		"7.20.0(720002029)",
	}
	for _, accountManagerVersion := range accountManagerVersions {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"am_version": accountManagerVersion,
			},
			FlagsToRemove: []string{"new_design_on=1"},
		})
	}
	// PASSP-33062
	taxiWhitelabelAppIDs := []string{
		"ru.yandex.goplatform.a.inhouse",
		"ru.yandex.goplatform.b.inhouse",
		"ru.yandex.goplatform.c.inhouse",
		"ru.yandex.goplatform.d.inhouse",
	}
	for _, taxiWhitelabelAppID := range taxiWhitelabelAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": taxiWhitelabelAppID,
			},
			FlagsToAdd: []string{"web_am_on=1", "web_login_on=1", "turn_mailing_accept_on=0"},
		})
	}

	vezetAppIDsBothOs := []string{
		"ru.rutaxi.vezet",
		"ru.rutaxi.vezet.develop",
	}
	vezetAppIDsAndroid := []string{
		"ru.rutaxi.vezet.beta",
		"ru.rutaxi.vezet.debug",
	}
	vezetAppIDsIos := []string{
		"ru.rutaxi.vezet.inhouse",
	}
	yangoAppIDsAndroid := []string{
		"com.yandex.yango",
		"com.yandex.yango.debug",
		"com.yandex.yango.beta",
		"com.yandex.yango.develop",
	}
	yangoAppIDsIos := []string{
		"ru.yandex.yango",
		"ru.yandex.yango.inhouse",
		"ru.yandex.yango.develop",
	}
	// PASSP-33422
	yangoAppIDs := append(yangoAppIDsAndroid, yangoAppIDsIos...)
	vezetAndYangoAppIDs := append(yangoAppIDs, vezetAppIDsIos...)
	for _, vezetAppID := range vezetAndYangoAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": vezetAppID,
			},
			FlagsToAdd: []string{"turn_mailing_accept_on=0"},
		})
	}
	// PASSP-33422, PASSP-33581
	vezetOldDesignAppIDs := append(vezetAppIDsBothOs, vezetAppIDsAndroid...)
	for _, vezetAppID := range vezetOldDesignAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": vezetAppID,
			},
			FlagsToAdd: []string{"new_design_on=0", "turn_mailing_accept_on=0"},
		})
	}
	// PASSP-35132
	newVezetAppIds := []string{
		"ru.yandex.vezet",
		"ru.yandex.vezet.debug",
		"ru.yandex.vezet.develop",
		"ru.yandex.vezet.inhouse",
	}
	uberAppIds := []string{
		"ru.yandex.uber",
		"ru.yandex.uber.develop",
		"ru.yandex.uber.inhouse",
		"ru.yandex.uber-by",
		"ru.yandex.uber-by.develop",
		"ru.yandex.uber-by.inhouse",
		"ru.yandex.uber-kz",
		"ru.yandex.uber-kz.develop",
		"ru.yandex.uber-kz.inhouse",
		"com.mlubv.uber-az",
		"ru.yandex.uber-az.develop",
		"com.mlubv.uber-az.inhouse",
	}
	for _, appID := range uberAppIds {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": appID,
			},
			FlagsToAdd: []string{"native_to_browser_exp=0", "turn_mailing_accept_on=0"},
		})
	}
	// PASSP-36018
	for _, appID := range newVezetAppIds {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": appID,
			},
			FlagsToAdd: []string{"new_design_on=0", "native_to_browser_exp=0", "turn_mailing_accept_on=0"},
		})
	}
	// PASSP-33432
	browserAppIDs := []string{
		// pp
		"ru.yandex.mobile.dev",
		"ru.yandex.mobile.inhouse",
		// browser
		"ru.yandex.mobile.search.inhouse",
		"ru.yandex.mobile.search.ipad.inhouse",
		"ru.yandex.mobile.search.develop",
		"ru.yandex.mobile.search.ipad.develop",
		"ru.yandex.mobile.search.ipad",
	}
	for _, browserAppID := range browserAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": browserAppID,
			},
			FlagsToAdd: []string{"native_to_browser_exp=0"},
		})
	}
	// PASSP-37052
	drivematicAppIDs := []string{
		"ru.yandex.mobile.drivematics.inhouse",
		"ru.yandex.mobile.drivematics",
		"ru.yandex.mobile.drivematics.rental.inhouse",
		"ru.yandex.mobile.drivematics.rental",
	}
	for _, drivematicAppID := range drivematicAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": drivematicAppID,
			},
			FlagsToAdd: []string{"native_to_browser_exp=0"},
		})
	}
	RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
		MatchKeyValue: map[string]string{
			"app_id": "ru.yandex.mobile.search",
		},
		FlagsToAdd: []string{"native_to_browser_exp=0", "turn_neophonish_reg_on=1"},
	})
	RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
		MatchKeyValue: map[string]string{
			"app_id": "ru.yandex.mobile",
		},
		FlagsToAdd: []string{"native_to_browser_exp=0", "turn_neophonish_reg_on=1"},
	})
	// PASSPORTDUTY-1169
	autoAppIDs := []string{
		"yandex.auto",
		"yandex.auto.settings",
		"ru.yandex.yandexnavi.auto",
		"yandex.auto.homescreen",
	}
	for _, autoAppID := range autoAppIDs {
		RewriteConfig = append(RewriteConfig, RewriteExperimentsExpression{
			MatchKeyValue: map[string]string{
				"app_id": autoAppID,
			},
			FlagsToAdd: []string{"web_am_on=0"},
		})
	}
}

func modifyFlags(experiments []Experiment, toAdd []string, toRemove []string) []Experiment {
	fastToRemove := make(map[string]bool)
	for _, flag := range toRemove {
		fastToRemove[flag] = true
	}

	seenFlags := make(map[string]bool)

	for i, experiment := range experiments {
		// удаляем лишние флаги
		var newFlags []string
		for _, flag := range experiment.Context.Passport.Flags {
			if !fastToRemove[flag] {
				newFlags = append(newFlags, flag)
			}
			seenFlags[flag] = true
		}
		// golang копирует айтем в локальную переменную, поэтому модицифировать надо по индексу
		experiments[i].Context.Passport.Flags = newFlags
	}

	// добавляем новые флаги
	var realToAdd []string
	for _, flag := range toAdd {
		if !seenFlags[flag] {
			realToAdd = append(realToAdd, flag)
		}
	}
	if len(realToAdd) > 0 {
		experiments = append(
			experiments,
			Experiment{
				Handler: "PASSPORT",
				TestID:  -1,
				Context: UaasContext{
					Passport: UaasFlags{
						Flags: realToAdd,
					},
				},
			})
	}
	return experiments
}

func matchParameters(expression RewriteExperimentsExpression, r map[string]string) bool {
	for expectedKey, expectedValue := range expression.MatchKeyValue {
		if r[expectedKey] != expectedValue {
			return false
		}
	}
	return true
}

func rewriteExperiments(
	experiments []Experiment, // данные, полученные от uaas
	expressions []RewriteExperimentsExpression, // правила переписывания экспериментов
	r map[string]string, // параметры из запроса
) []Experiment {

	for _, expression := range expressions {
		// short-circuit кучи правил
		// этот код не в matchParameters, потому что функция оч complex для инлайна
		if len(expression.MatchKeyValue) == 1 {
			expectedAppID, ok := expression.MatchKeyValue["app_id"]
			if ok {
				if expectedAppID == r["app_id"] {
					experiments = modifyFlags(experiments, expression.FlagsToAdd, expression.FlagsToRemove)
				}
				continue
			}
		}
		if matchParameters(expression, r) {
			experiments = modifyFlags(experiments, expression.FlagsToAdd, expression.FlagsToRemove)
		}
	}

	return experiments
}
