package uaasproxy

import (
	"unsafe"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jwriter"
)

var nullBytes = []byte("null")

func isNilInterface(i interface{}) bool {
	return (*[2]uintptr)(unsafe.Pointer(&i))[1] == 0
}

func marshal(v easyjson.Marshaler) ([]byte, error) {
	if isNilInterface(v) {
		return nullBytes, nil
	}

	w := jwriter.Writer{
		// https://st.yandex-team.ru/PASSP-28794
		Flags: jwriter.NilMapAsEmpty | jwriter.NilSliceAsEmpty,
	}
	v.MarshalEasyJSON(&w)
	return w.BuildBytes()
}
