package uaasproxy

import (
	"sync"

	"a.yandex-team.ru/passport/shared/golibs/unistat"
)

var (
	once     sync.Once
	instance Unistat
)

func InitUnistat() Unistat {
	once.Do(func() {
		uaasHgram, err := unistat.DefaultChunk.CreateSignalHgram(
			"uaas.duration.ms",
			[]float64{0, 25, 50, 75, 100, 150, 200, 250, 500, 1000},
		)
		if err != nil {
			panic(err)
		}
		divHgram, err := unistat.DefaultChunk.CreateSignalHgram(
			"divcard.duration.ms",
			[]float64{0, 1, 2, 3, 5, 6, 10, 20, 30, 40, 50},
		)
		if err != nil {
			panic(err)
		}

		instance = Unistat{
			requestsByPath:                    unistat.DefaultChunk.CreateSignalSet("in.requests."),
			uaasDuration:                      uaasHgram,
			uaasFailed:                        unistat.DefaultChunk.CreateSignalDiff("uaas.errors"),
			uaasCancelled:                     unistat.DefaultChunk.CreateSignalDiff("uaas.cancelled"),
			uaasSuccess:                       unistat.DefaultChunk.CreateSignalDiff("uaas.success"),
			uaasTotal:                         unistat.DefaultChunk.CreateSignalDiff("uaas.total"),
			poolFlags:                         unistat.DefaultChunk.CreateSignalDiff("pool.flags"),
			poolExperiments:                   unistat.DefaultChunk.CreateSignalDiff("pool.experiments"),
			poolResponses:                     unistat.DefaultChunk.CreateSignalDiff("pool.responses"),
			divTotal:                          unistat.DefaultChunk.CreateSignalDiff("divcard.total"),
			divSuccess:                        unistat.DefaultChunk.CreateSignalDiff("divcard.success"),
			divFailed:                         unistat.DefaultChunk.CreateSignalDiff("divcard.errors"),
			divDuration:                       divHgram,
			divRuDarkDefaultRationale:         unistat.DefaultChunk.CreateSignalDiff("divcard.ru.dark.default_rationale"),
			divEnDarkDefaultRationale:         unistat.DefaultChunk.CreateSignalDiff("divcard.en.dark.default_rationale"),
			divRuLightDefaultRationale:        unistat.DefaultChunk.CreateSignalDiff("divcard.ru.light.default_rationale"),
			divEnLightDefaultRationale:        unistat.DefaultChunk.CreateSignalDiff("divcard.en.light.default_rationale"),
			divRuDarkDefaultBlockedRationale:  unistat.DefaultChunk.CreateSignalDiff("divcard.ru.dark.default_blocked_rationale"),
			divEnDarkDefaultBlockedRationale:  unistat.DefaultChunk.CreateSignalDiff("divcard.en.dark.default_blocked_rationale"),
			divRuLightDefaultBlockedRationale: unistat.DefaultChunk.CreateSignalDiff("divcard.ru.light.default_blocked_rationale"),
			divEnLightDefaultBlockedRationale: unistat.DefaultChunk.CreateSignalDiff("divcard.en.light.default_blocked_rationale"),
		}
	})
	return instance
}
