package uaasproxy

import (
	"net"
	"net/http"
	"strconv"
	"strings"
)

type RoundTripFunc func(req *http.Request) (*http.Response, error)

func (f RoundTripFunc) RoundTrip(req *http.Request) (*http.Response, error) {
	return f(req)
}

func NewTestClient(fn RoundTripFunc) *http.Client {
	return &http.Client{
		Transport: fn,
	}
}

func isIPAddress(value string) bool {
	return net.ParseIP(value) != nil
}

func arrayAtoI(arr []string) ([]int, error) {
	var ints []int
	for _, x := range arr {
		x = strings.Trim(x, " ")
		digit, err := strconv.Atoi(x)
		if err != nil {
			return nil, err
		}
		ints = append(ints, digit)
	}
	return ints, nil
}

func arrayItoA(ints []int) []string {
	var xs []string
	for _, x := range ints {
		str := strconv.Itoa(x)
		xs = append(xs, str)
	}
	return xs
}

func getHeaderValue(values []string) string {
	if len(values) > 0 {
		return values[0]
	} else {
		return ""
	}
}
