#!/usr/bin/env bash
set -e

if [ -z "$1" ]
then
    DATE=`date -d "1 day ago" '+%Y-%m-%d'`
else
    DATE="$1"
fi

export YT_POOL=ecosystem
export YT_TOKEN=`cat /etc/yandex/passport-userdata/yt.token`

/usr/bin/yandex/passport-userdata/wait_for_tables.sh "$DATE"
/usr/bin/yandex/passport-userdata/download_uids.sh `cat /etc/yandex/environment.type` "$DATE"
/usr/bin/yandex/passport-userdata/download_userinfo.sh
/usr/bin/yandex/passport-userdata/upload.sh `cat /etc/yandex/environment.type` "$DATE"
/usr/bin/yandex/passport-userdata/merge.sh "$DATE"
/usr/bin/yandex/passport-userdata/transform_yt.sh `cat /etc/yandex/environment.type` "$DATE"
/usr/bin/yandex/passport-userdata/set_ttl.sh `cat /etc/yandex/environment.type` "$DATE"
/usr/bin/yandex/passport-userdata/cleanup.sh `cat /etc/yandex/environment.type` "$DATE"
rm /var/lib/yandex/passport-userdata/userdata_*
