package internal

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

type UnistatServer struct {
	BlackboxDuration *unistat.Histogram
	BlackboxErrors   *unistat.Numeric
	BlackboxTotal    *unistat.Numeric
	BlackboxSuccess  *unistat.Numeric
	Exported         *unistat.Numeric
}

func GetNewUnistatServer() *UnistatServer {
	serv := &UnistatServer{
		BlackboxDuration: unistat.NewHistogram("blackbox.duration.ms", 0,
			aggr.Histogram(),
			[]float64{0, 10, 20, 25, 50, 75, 100, 150, 200, 250, 500, 1000}),
		BlackboxErrors:  unistat.NewNumeric("blackbox.errors", 1, aggr.Counter(), unistat.Sum),
		BlackboxTotal:   unistat.NewNumeric("blackbox.total", 1, aggr.Counter(), unistat.Sum),
		BlackboxSuccess: unistat.NewNumeric("blackbox.success", 1, aggr.Counter(), unistat.Sum),
		Exported:        unistat.NewNumeric("exported.total", 1, aggr.Counter(), unistat.Sum),
	}
	unistat.Register(serv.BlackboxDuration)
	unistat.Register(serv.BlackboxErrors)
	unistat.Register(serv.BlackboxTotal)
	unistat.Register(serv.BlackboxSuccess)
	unistat.Register(serv.Exported)
	return serv
}

func (serv *UnistatServer) HandlerUnistat(logger log.Logger) func(rw http.ResponseWriter, req *http.Request) {
	return func(rw http.ResponseWriter, req *http.Request) {
		bytes, err := unistat.MarshalJSON()
		if err != nil {
			http.Error(rw, err.Error(), http.StatusInternalServerError)
			return
		}
		rw.Header().Set("Content-Type", "application/json; charset=utf-8")
		if _, err := rw.Write(bytes); err != nil {
			logger.Fatalf("Unistat Write Error: %v", err)
		}
	}
}
