package internal

import (
	"net"
)

func GetCurrentIPAddress() string {
	addrs, err := net.InterfaceAddrs()
	if err != nil {
		panic(err)
	}

	for _, a := range addrs {
		// To4 == nil для получения только IPv6 адресов
		if ipnet, ok := a.(*net.IPNet); ok && !ipnet.IP.IsLoopback() && ipnet.IP.To4() == nil {
			return ipnet.IP.String()
		}
	}
	return "127.0.0.1"
}
