package main

import (
	"fmt"
	"reflect"

	"a.yandex-team.ru/passport/backend/userdata/yt_schema/common"
)

func main() {
	exportEntry := common.ExportEntry{}
	e := reflect.ValueOf(&exportEntry).Elem()

	knownTypes := map[string]string{
		"*[]int64":              "{type_name=optional; item={type_name=list; item=int64}}",
		"*common.UnicodeEscape": "{type_name=optional; item=utf8}",
		"*int64":                "{type_name=optional; item=int64}",
		"[]int64":               "{type_name=list; item=int64}",
		"uint64":                "int64",
		"bool":                  "bool",
		"common.UnicodeEscape":  "utf8",
		"*string":               "{type_name=optional; item=string}",
		"string":                "string",
		"[]string":              "{type_name=list; item=string}",
	}

	fmt.Printf("<schema=[")
	for i := 0; i < e.NumField(); i++ {
		varName := e.Type().Field(i).Tag.Get("json")
		varType := e.Type().Field(i).Type
		fmt.Printf("{name = %v; type_v3 = %v}", varName, knownTypes[fmt.Sprintf("%+v", varType)])
		if i < e.NumField()-1 {
			fmt.Printf("; ")
		}
	}
	fmt.Printf("]>")
}
