package common

import (
	"github.com/mailru/easyjson"

	"a.yandex-team.ru/library/go/yandex/blackbox"
)

func EncodeExportEntry(ee ExportEntry) ([]byte, error) {
	return easyjson.Marshal(ee)
}

//easyjson:json
type ExportEntry struct {
	UID                                 string   `json:"uid"`
	Login                               string   `json:"login"`
	Aliases                             []int64  `json:"alias"`
	HasPlus                             bool     `json:"has_plus"`
	HasPlusCashback                     bool     `json:"has_plus_cashback"`
	SecurePhoneID                       *int64   `json:"secure_phone_id"`
	BankPhoneNumber                     *string  `json:"bank_phone_number"`
	HasSecurePhoneID                    bool     `json:"has_secure_phone_id"`
	AccountEnabled                      bool     `json:"account_enabled"`
	DefaultAvatar                       *string  `json:"default_avatar"`
	HasDefaultAvatar                    bool     `json:"has_default_avatar"`
	DisplayName                         *string  `json:"display_name"`
	HasDisplayName                      bool     `json:"has_display_name"`
	RegDate                             *int64   `json:"reg_date"`
	SID                                 []int64  `json:"sid"`
	FirstName                           *string  `json:"firstname"`
	HasFirstName                        bool     `json:"has_firstname"`
	LastName                            *string  `json:"lastname"`
	HasLastName                         bool     `json:"has_lastname"`
	UserDefinedLogin                    *string  `json:"user_defined_login"`
	Birthday                            *string  `json:"birthday"`
	HasBirthday                         bool     `json:"has_birthday"`
	PasswordIsChangingRequiredTimestamp *int64   `json:"password_is_changing_required_timestamp"`
	HasAppPassword                      bool     `json:"has_app_password"`
	Language                            *string  `json:"language"`
	SecurePhoneNumber                   *string  `json:"secure_phone_number"`
	ShowFIOInPublicName                 bool     `json:"is_show_fio_in_public_name"`
	Gender                              *string  `json:"gender"`
	Karma                               uint64   `json:"karma"`
	Country                             *string  `json:"country"`
	HasPassword                         bool     `json:"has_password"`
	HasHint                             bool     `json:"has_hint"`
	PasswordQuality                     *int64   `json:"password_quality"`
	PasswordUpdatedTimestamp            *int64   `json:"password_updated_timestamp"`
	PasswordChangingReason              *int64   `json:"password_changing_reason"`
	PhoneNumbers                        []string `json:"phone_numbers"`
	PublicID                            *string  `json:"public_id"`
	PublicName                          *string  `json:"public_name"`
	SMS2FA                              bool     `json:"has_sms_2fa"`
	FamilyID                            *string  `json:"family_id"`
}

var AliasesToQuery = []blackbox.UserAlias{
	blackbox.UserAliasPortal,
	blackbox.UserAliasMail,
	blackbox.UserAliasNarodmail,
	blackbox.UserAliasNarod,
	blackbox.UserAliasLite,
	blackbox.UserAliasSocial,
	//blackbox.UserAliasPdd,
	//blackbox.UserAliasPddalias,
	blackbox.UserAliasPhonish,
	blackbox.UserAliasMailish,
	blackbox.UserAliasYandexoid,
	blackbox.UserAliasKinopoiskid,
	blackbox.UserAliasUberid,
	blackbox.UserAliasYambot,
	blackbox.UserAliasKolonkish,
	blackbox.UserAliasPublicID,
	//blackbox.UserAliasOldPublicID,
	blackbox.UserAliasNeophonish,
}

var AttributesToQuery = []blackbox.UserAttribute{
	blackbox.UserAttributeAccountRegistrationDatetime,
	blackbox.UserAttribute("2"), // user defined login
	blackbox.UserAttribute("3"),
	blackbox.UserAttributeAvatarDefault,
	blackbox.UserAttributePasswordQuality,
	blackbox.UserAttributePersonFirstname,
	blackbox.UserAttributePersonLastname,
	blackbox.UserAttributePersonGender,
	blackbox.UserAttributePersonBirthday,
	blackbox.UserAttributePersonLanguage,
	blackbox.UserAttributeAvatarDefault,
	blackbox.UserAttribute("110"),
	blackbox.UserAttributePasswordWebOnlyaccountEnableAppPassword,
	blackbox.UserAttribute("185"),
	blackbox.UserAttribute("195"),
	blackbox.UserAttribute("200"),
	blackbox.UserAttributeAccountHavePlus,
	blackbox.UserAttribute("1008"),
	blackbox.UserAttribute("1025"),
	blackbox.UserAttributePasswordUpdateDatetime,
	blackbox.UserAttributePasswordForcedChangingReason,
	blackbox.UserAttributePersonCountry,
}

var PhoneAttributesToQuery = []blackbox.PhoneAttribute{
	blackbox.PhoneAttributePhoneE164Number,
	blackbox.PhoneAttributePhoneIsSecured,
	blackbox.PhoneAttribute("109"), // is bank phone number
}

var DBFieldsToQuery = []blackbox.UserDBField{
	blackbox.UserDBField("subscription.suid.2"),
	blackbox.UserDBField("subscription.suid.5"),
	blackbox.UserDBField("subscription.suid.6"),
	blackbox.UserDBField("subscription.suid.8"),
	blackbox.UserDBField("subscription.suid.9"),
	blackbox.UserDBField("subscription.suid.14"),
	blackbox.UserDBField("subscription.suid.16"),
	blackbox.UserDBField("subscription.suid.17"),
	blackbox.UserDBField("subscription.suid.19"),
	blackbox.UserDBField("subscription.suid.23"),
	blackbox.UserDBField("subscription.suid.24"),
	blackbox.UserDBField("subscription.suid.25"),
	blackbox.UserDBField("subscription.suid.26"),
	blackbox.UserDBField("subscription.suid.27"),
	blackbox.UserDBField("subscription.suid.29"),
	blackbox.UserDBField("subscription.suid.30"),
	blackbox.UserDBField("subscription.suid.31"),
	blackbox.UserDBField("subscription.suid.33"),
	blackbox.UserDBField("subscription.suid.36"),
	blackbox.UserDBField("subscription.suid.37"),
	blackbox.UserDBField("subscription.suid.38"),
	blackbox.UserDBField("subscription.suid.39"),
	blackbox.UserDBField("subscription.suid.40"),
	blackbox.UserDBField("subscription.suid.41"),
	blackbox.UserDBField("subscription.suid.42"),
	blackbox.UserDBField("subscription.suid.44"),
	blackbox.UserDBField("subscription.suid.47"),
	blackbox.UserDBField("subscription.suid.48"),
	blackbox.UserDBField("subscription.suid.49"),
	blackbox.UserDBField("subscription.suid.50"),
	blackbox.UserDBField("subscription.suid.51"),
	blackbox.UserDBField("subscription.suid.52"),
	blackbox.UserDBField("subscription.suid.53"),
	blackbox.UserDBField("subscription.suid.54"),
	blackbox.UserDBField("subscription.suid.55"),
	blackbox.UserDBField("subscription.suid.57"),
	blackbox.UserDBField("subscription.suid.58"),
	blackbox.UserDBField("subscription.suid.59"),
	blackbox.UserDBField("subscription.suid.60"),
	blackbox.UserDBField("subscription.suid.64"),
	blackbox.UserDBField("subscription.suid.67"),
	blackbox.UserDBField("subscription.suid.68"),
	blackbox.UserDBField("subscription.suid.76"),
	blackbox.UserDBField("subscription.suid.77"),
	blackbox.UserDBField("subscription.suid.78"),
	blackbox.UserDBField("subscription.suid.80"),
	blackbox.UserDBField("subscription.suid.81"),
	blackbox.UserDBField("subscription.suid.82"),
	blackbox.UserDBField("subscription.suid.83"),
	blackbox.UserDBField("subscription.suid.84"),
	blackbox.UserDBField("subscription.suid.85"),
	blackbox.UserDBField("subscription.suid.86"),
	blackbox.UserDBField("subscription.suid.87"),
	blackbox.UserDBField("subscription.suid.88"),
	blackbox.UserDBField("subscription.suid.89"),
	blackbox.UserDBField("subscription.suid.90"),
	blackbox.UserDBField("subscription.suid.91"),
	blackbox.UserDBField("subscription.suid.93"),
	blackbox.UserDBField("subscription.suid.100"),
	blackbox.UserDBField("subscription.suid.102"),
	blackbox.UserDBField("subscription.suid.104"),
	blackbox.UserDBField("subscription.suid.118"),
	blackbox.UserDBField("subscription.suid.119"),
	blackbox.UserDBField("subscription.suid.125"),
	blackbox.UserDBField("subscription.suid.666"),
	blackbox.UserDBField("subscription.suid.667"),
	blackbox.UserDBField("subscription.suid.668"),
	blackbox.UserDBField("subscription.suid.670"),
	blackbox.UserDBField("subscription.suid.671"),
	blackbox.UserDBField("subscription.suid.672"),
	blackbox.UserDBField("subscription.suid.669"),
}
