from cffi import FFI


ffi = FFI()


cdef void* from_ffi_addr(object cdata):
    """
    Получает указатель из объекта ffi.CData
    """
    cdef unsigned long addr = int(ffi.cast('size_t', ffi.cast('void*', cdata)))
    return <void*>addr


cdef object to_ffi_addr(void* addr):
    """
    Получает объект ffi.CData из указателя
    """
    return ffi.cast('void*', <object><unsigned long>addr)
